/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.model.data;

import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import slimeknights.mantle.client.model.ModelProperty;
import slimeknights.mantle.client.model.data.IModelData;

public class SinglePropertyData<D>
implements IModelData {
    private final ModelProperty<D> property;
    private D data = null;

    public SinglePropertyData(ModelProperty<D> property, @Nullable D data) {
        Preconditions.checkArgument((boolean)property.test(data), (Object)"Value is invalid for this property");
        this.property = property;
        this.data = data;
    }

    @Override
    public boolean hasProperty(ModelProperty<?> prop) {
        return prop == this.property;
    }

    @Override
    @Nullable
    public <T> T getData(ModelProperty<T> prop) {
        if (prop == this.property) {
            return (T)this.data;
        }
        return null;
    }

    @Override
    @Nullable
    public <T> T setData(ModelProperty<T> prop, T data) {
        Preconditions.checkArgument((boolean)prop.test(data), (Object)"Value is invalid for this property");
        if (prop == this.property) {
            this.data = data;
            return data;
        }
        return null;
    }

    public SinglePropertyData(ModelProperty<D> property) {
        this.property = property;
    }
}

